/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.fluid;

import com.google.common.collect.ImmutableMap;
import com.renyigesai.immortalers_delight.fluid.ImmortalersDelightFluids;
import com.renyigesai.immortalers_delight.recipe.HotSpringRecipe;
import com.renyigesai.immortalers_delight.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.tag.ModTags;

public class HotSpringFluidsBlock
extends LiquidBlock {
    public HotSpringFluidsBlock() {
        super(ImmortalersDelightFluids.HOT_SPRING, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_60978_(100.0f).m_60910_().m_222994_().m_278788_().m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_279557_).m_280170_().m_60977_());
    }

    private Optional<HotSpringRecipe> getCurrentRecipe(Level level, List<ItemStack> list) {
        SimpleContainer inventory = new SimpleContainer(list.size());
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        for (int i = 0; i < inputs.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)inputs.get(i));
        }
        return level.m_7465_().m_44015_((RecipeType)HotSpringRecipe.Type.INSTANCE, (Container)inventory, level);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        boolean isNether;
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (HotSpringFluidsBlock.m_49918_((VoxelShape)pLevel.m_8055_(pPos.m_7494_()).m_60812_((BlockGetter)pLevel, pPos.m_7494_()), (Direction)Direction.DOWN)) {
            return;
        }
        double x = (double)pPos.m_123341_() + 0.5;
        double y = pPos.m_7494_().m_123342_();
        double z = (double)pPos.m_123343_() + 0.5;
        Random random = new Random();
        boolean bl = isNether = pLevel.m_46472_() == Level.f_46429_;
        if (isNether && pLevel.m_46467_() % 10L == 0L || this.isHeatSources(pLevel, pPos)) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123759_, x + random.nextDouble(-0.5, 0.5), y, z + random.nextDouble(-0.5, 0.5), 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x + random.nextDouble(-0.5, 0.5), y, z + random.nextDouble(-0.5, 0.5), 0.0, 0.0, 0.0);
        } else if (pLevel.m_46467_() % 20L == 0L) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123759_, x + random.nextDouble(-0.5, 0.5), y, z + random.nextDouble(-0.5, 0.5), 0.0, 0.0, 0.0);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.craftTick((Level)pLevel, pPos);
    }

    public boolean isHeatSources(Level level, BlockPos pos) {
        BlockState stateFurtherBelow;
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (stateBelow.m_204336_(ModTags.HEAT_SOURCES)) {
            return stateBelow.m_61138_((Property)BlockStateProperties.f_61443_) ? (Boolean)stateBelow.m_61143_((Property)BlockStateProperties.f_61443_) : !stateBelow.m_60819_().m_192917_((Fluid)ImmortalersDelightFluids.HOT_SPRING.get());
        }
        if (stateBelow.m_204336_(ModTags.HEAT_CONDUCTORS) && (stateFurtherBelow = level.m_8055_(pos.m_6625_(2))).m_204336_(ModTags.HEAT_SOURCES)) {
            if (stateFurtherBelow.m_61138_((Property)BlockStateProperties.f_61443_)) {
                return (Boolean)stateFurtherBelow.m_61143_((Property)BlockStateProperties.f_61443_);
            }
            return true;
        }
        if (stateBelow.m_280296_() && level.m_46472_() == Level.f_46429_) {
            ImmutableMap posMap = new ImmutableMap.Builder().put((Object)0, (Object)pos.m_122012_()).put((Object)1, (Object)pos.m_122019_()).put((Object)2, (Object)pos.m_122024_()).put((Object)3, (Object)pos.m_122029_()).build();
            for (int i = 0; i < 4 && posMap.get(i) != null; ++i) {
                BlockState stateAround = level.m_8055_(Objects.requireNonNull((BlockPos)posMap.get(i)));
                if (!stateAround.m_60819_().m_192917_((Fluid)ImmortalersDelightFluids.HOT_SPRING.get())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void craftTick(Level level, BlockPos pos) {
        List itemEntityList = level.m_45976_(ItemEntity.class, new AABB(pos, pos).m_82377_(1.0, 1.0, 1.0));
        if (itemEntityList.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (ItemEntity entity : itemEntityList) {
            ItemStack item = entity.m_32055_();
            if (item.m_41619_() || item.m_41613_() != 1) continue;
            stackList.add(item);
        }
        if (stackList.isEmpty()) {
            return;
        }
        Optional<HotSpringRecipe> recipeOptional = this.getCurrentRecipe(level, stackList);
        if (recipeOptional.isEmpty()) {
            return;
        }
        HotSpringRecipe recipe = recipeOptional.get();
        ItemStack resultItem = recipe.m_8043_(level.m_9598_()).m_41777_();
        for (ItemEntity itemEntity : itemEntityList) {
            itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        ItemUtils.spawnItemEntity(level, resultItem, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                Vec3 vec3 = new Vec3((double)((level.f_46441_.m_188501_() * 2.0f - 1.0f) * 0.4f), (double)level.f_46441_.m_188503_(4) * 0.25 - 0.25, (double)((level.f_46441_.m_188501_() * 2.0f - 1.0f) * 0.4f));
                for (int j = 1; j <= 5; ++j) {
                    double x = (double)pos.m_123341_() + vec3.f_82479_ * (double)j / 5.0;
                    double y = (double)pos.m_123342_() + vec3.f_82480_ * (double)j / 5.0;
                    double z = (double)pos.m_123343_() + vec3.f_82481_ * (double)j / 5.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 8, 0.0, 0.0, 0.0, 0.0);
                }
            }
            level.m_247517_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.m_7892_(pState, pLevel, pPos, pEntity);
        if (!this.isHeatSources(pLevel, pPos)) {
            if (pEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pEntity;
                if (living.f_19797_ % 25 == 0) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 50, 0, false, false));
                }
            }
            return;
        }
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            if (!living.m_6336_().equals(MobType.f_21641_) && !living.m_5825_()) {
                living.m_6469_(pLevel.m_269111_().m_269387_(), 2.0f);
            }
            if (living.m_6336_().equals(MobType.f_21641_) && living.f_19797_ % 25 == 0) {
                living.m_5634_(1.0f);
            }
        } else if (pEntity instanceof ItemEntity) {
            pLevel.m_186460_(pPos, (Block)this, 5);
        }
    }
}

